package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.dms.biz.Document;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestRequestLocationDocument extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);
		
		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		Group group = pers.getGroups().iterator().next();
		Assert.assertNotNull(group);
		Assert.assertTrue(group.getId() > 0);

		Location location = pers.getLocation();
		Assert.assertNotNull(location);
		Assert.assertTrue(location.getId() > 0);
		
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);
		
		DocumentTemplate template = dtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Document doc = Document.create(request, template, pers.getName());
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);

		RequestLocationDocument rald = RequestLocationDocument.create(request, location, doc);
		Assert.assertNotNull(rald);
		Assert.assertTrue(rald.getId() > 0);
		
		List<RequestLocationDocument> raldList = RequestLocationDocument.listByRequestId(request.getId());
		Assert.assertNotNull(raldList);
		Assert.assertTrue(raldList.size() > 0);
		Assert.assertTrue(raldList.contains(rald));
		
		raldList = RequestLocationDocument.listByRequestId(10000);
		Assert.assertNotNull(raldList);
		Assert.assertEquals(raldList.size(), 0);

	}

	@Test
	public void testTwo() throws Exception {
		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);
		
		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		Group group = pers.getGroups().iterator().next();
		Assert.assertNotNull(group);
		Assert.assertTrue(group.getId() > 0);

		Location location = pers.getLocation();
		Assert.assertNotNull(location);
		Assert.assertTrue(location.getId() > 0);
		
		List<DocumentTemplate> dtList = DocumentTemplate.listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);
		
		DocumentTemplate template = dtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Document doc = Document.create(request, template, pers.getName());
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);

		RequestLocationDocument rald = RequestLocationDocument.create(request, location, doc);
		Assert.assertNotNull(rald);
		Assert.assertTrue(rald.getId() > 0);
		
		List<RequestLocationDocument> raldList = RequestLocationDocument.listByRequestId(request.getId());
		Assert.assertNotNull(raldList);
		Assert.assertTrue(raldList.size() > 0);
		Assert.assertTrue(raldList.contains(rald));

		rald.delete();

		raldList = RequestLocationDocument.listByRequestId(request.getId());
		Assert.assertNotNull(raldList);
		Assert.assertFalse(raldList.contains(rald));

	}
}
